<?php
/**
 * Astra Child Theme functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Astra Child
 * @since 1.0.0
 */

/**
 * Define Constants
 */
define( 'CHILD_THEME_ASTRA_CHILD_VERSION', '1.0.0' );

/**
 * Enqueue styles
 */
function child_enqueue_styles() {

	wp_enqueue_style( 'astra-child-theme-css', get_stylesheet_directory_uri() . '/style.css', array('astra-theme-css'), CHILD_THEME_ASTRA_CHILD_VERSION, 'all' );

}

add_action( 'wp_enqueue_scripts', 'child_enqueue_styles', 15 );

// Register Custom Post Type: Vehicle
function create_vehicle_post_type() {
    register_post_type('vehicle',
        array(
            'labels' => array(
                'name' => __('Vehicles'),
                'singular_name' => __('Vehicle'),
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array('title', 'editor', 'thumbnail'),
        )
    );
}
add_action('init', 'create_vehicle_post_type');




function get_unique_acf_values($field_name) {
    global $wpdb;
    $results = $wpdb->get_col($wpdb->prepare("
        SELECT DISTINCT meta_value FROM {$wpdb->postmeta} 
        WHERE meta_key = %s AND meta_value != ''
        ORDER BY meta_value ASC
    ", $field_name));
    return $results;
}

function vehicle_listing_shortcode() {
    // Fetch unique values from ACF fields
    $makes = get_unique_acf_values('makes');
    $years = get_unique_acf_values('year');
    $transmissions = get_unique_acf_values('transmission');
    $drivetrains = get_unique_acf_values('drivetrain');
  // Fetch vehicle categories
$vehicle_categories = get_categories([
    'taxonomy'   => 'category',
    'hide_empty' => true,
]);

    ob_start();
    ?>
    <div id="vehicle-filter-container">
        <div class="filter-section">
            <h3>Search</h3>
            <form id="search-form">
                <input type="text" id="vehicle-search-input" placeholder="Search for vehicles..." />
            </form>
<h3>Category</h3>
<div id="vehicle-category">
    <?php foreach ($vehicle_categories as $category): ?>
        <input type="checkbox" class="filter-checkbox" data-filter="category" value="<?php echo esc_attr($category->term_id); ?>" /> 
        <?php echo esc_html($category->name); ?><br />
    <?php endforeach; ?>
</div>

            <h3>Make</h3>
            <div id="vehicle-make">
                
                <?php foreach ($makes as $make): ?>
                    <input type="checkbox" class="filter-checkbox" data-filter="make" value="<?php echo esc_attr($make); ?>" /> <?php echo esc_html($make); ?><br />
                <?php endforeach; ?>
            </div>

            <h3>Year</h3>
            <div id="vehicle-year"> 
             
                <?php foreach ($years as $year): ?>
                    <input type="checkbox" class="filter-checkbox" data-filter="year" value="<?php echo esc_attr($year); ?>" /> <?php echo esc_html($year); ?><br />
                <?php endforeach; ?>
            </div>

            <h3>Transmission</h3>
            <div id="vehicle-transmission">
                
                <?php foreach ($transmissions as $transmission): ?>
                    <input type="checkbox" class="filter-checkbox" data-filter="transmission" value="<?php echo esc_attr($transmission); ?>" /> <?php echo esc_html($transmission); ?><br />
                <?php endforeach; ?>
            </div>

            <h3>Drivetrain</h3>
            <div id="vehicle-drivetrain">
                
                <?php foreach ($drivetrains as $drivetrain): ?>
                    <input type="checkbox" class="filter-checkbox" data-filter="drivetrain" value="<?php echo esc_attr($drivetrain); ?>" /> <?php echo esc_html($drivetrain); ?><br />
                <?php endforeach; ?>
            </div>
        </div>

        <div class="vehicle-grid-section">
            <div id="vehicle-posts" class="vehicle-grid">
                <p>Loading vehicles...</p>
            </div>
        </div>
    </div>

    <script type="text/javascript">
    jQuery(document).ready(function ($) {
        function fetchVehicles() {
            var searchTerm = $('#vehicle-search-input').val();
            var makes = [];
            var years = [];
            var transmissions = [];
            var drivetrains = [];
var categories = [];
$('.filter-checkbox[data-filter="category"]:checked').each(function() {
    categories.push($(this).val());
});

            $('.filter-checkbox[data-filter="make"]:checked').each(function() {
                makes.push($(this).val());
            });

            $('.filter-checkbox[data-filter="year"]:checked').each(function() {
                years.push($(this).val());
            });

            $('.filter-checkbox[data-filter="transmission"]:checked').each(function() {
                transmissions.push($(this).val());
            });

            $('.filter-checkbox[data-filter="drivetrain"]:checked').each(function() {
                drivetrains.push($(this).val());
            });

            $.ajax({
                url: '<?php echo admin_url('admin-ajax.php'); ?>',
                type: 'POST',
                data: {
                    action: 'filter_vehicles',
                    search_term: searchTerm,
                    makes: makes,
                    years: years,
                    transmissions: transmissions,
                    drivetrains: drivetrains
                },
				data: {
    action: 'filter_vehicles',
    search_term: searchTerm,
    makes: makes,
    years: years,
    transmissions: transmissions,
    drivetrains: drivetrains,
    categories: categories // Added category
},

                beforeSend: function () {
                    $('#vehicle-posts').html('<p>Loading...</p>');
                },
                success: function (response) {
                    $('#vehicle-posts').html(response.html);
                }
            });
        }

        $('.filter-checkbox').on('change', fetchVehicles);
        $('#vehicle-search-input').on('input', fetchVehicles);

        fetchVehicles(); // Load vehicles initially
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('vehicle_listing', 'vehicle_listing_shortcode');

function filter_vehicles_ajax_handler() {
    $search_term = isset($_POST['search_term']) ? sanitize_text_field($_POST['search_term']) : '';
    $makes = isset($_POST['makes']) ? $_POST['makes'] : [];
    $years = isset($_POST['years']) ? $_POST['years'] : [];
    $transmissions = isset($_POST['transmissions']) ? $_POST['transmissions'] : [];
    $drivetrains = isset($_POST['drivetrains']) ? $_POST['drivetrains'] : [];
	$categories = isset($_POST['categories']) ? array_map('intval', $_POST['categories']) : [];


    $meta_query = ['relation' => 'AND'];

    if (!empty($makes)) {
        $meta_query[] = [
            'key' => 'makes',
            'value' => $makes,
            'compare' => 'IN'
        ];
    }
    if (!empty($years)) {
        $meta_query[] = [
            'key' => 'year',
            'value' => $years,
            'compare' => 'IN'
        ];
    }
    if (!empty($transmissions)) {
        $meta_query[] = [
            'key' => 'transmission',
            'value' => $transmissions,
            'compare' => 'IN'
        ];
    }
    if (!empty($drivetrains)) {
        $meta_query[] = [
            'key' => 'drivetrain',
            'value' => $drivetrains,
            'compare' => 'IN'
        ];
    }

    $args = [
        'post_type' => 'vehicle',
        'posts_per_page' => -1,
        's' => $search_term,
        'meta_query' => $meta_query
    ];
	
	$args = [
    'post_type'      => 'vehicle',
    'posts_per_page' => -1,
    's'              => $search_term,
    'meta_query'     => $meta_query,
    'tax_query'      => !empty($categories) ? [
        [
            'taxonomy' => 'category',
            'field'    => 'term_id',
            'terms'    => $categories,
        ],
    ] : [],
];


    $query = new WP_Query($args);
    $response = ['html' => ''];

    if ($query->have_posts()) {
        ob_start();
        while ($query->have_posts()) {
            $query->the_post();
            ?>
            <div class="vehicle-item">
                <a href="<?php the_permalink(); ?>" class="vehicle-link">
                    <div class="vehicle-image">
                        <?php if (has_post_thumbnail()): ?>
                            <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                        <?php endif; ?>
                    </div>
                    <div class="vehicle-content">
                        <p class="Body type"><?php the_field('body_type'); ?></p>
                        <h3 class="vehicle-title"><?php the_title(); ?></h3>
                        <div class="inner-col">
                            <p class="vehicle-year"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/calender.png"> <?php the_field('year'); ?></p>
                            <p class="Mileage"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/meter.png"><?php the_field('mileage'); ?></p>
                            <p class="vehicle-transmission"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/gear.png"><?php the_field('transmission'); ?></p>
                        </div>
                      <p class="pricing">
    <?php 
        $price = get_field('price'); 
        if (!$price) {
            echo 'N/A'; // Show "N/A" if price is missing
        } elseif (strtolower(trim($price)) === 'sold') {
            echo '<span class="sold">SOLD</span>'; // Show "SOLD" without "$"
        } elseif (is_numeric(str_replace(',', '', trim($price)))) { 
            echo '$' . number_format((float) str_replace(',', '', trim($price)), 0); // Show price with "$"
        } else {
            echo esc_html($price); // Fallback for unexpected input
        }
    ?>
</p>


                        <button class="view-butt"> View Car</button>
                    </div>
                </a>
            </div>
            <?php
        }
        $response['html'] = ob_get_clean();
    } else {
        $response['html'] = '<p>No vehicles found.</p>';
    }

    wp_send_json($response);
}
add_action('wp_ajax_filter_vehicles', 'filter_vehicles_ajax_handler');
add_action('wp_ajax_nopriv_filter_vehicles', 'filter_vehicles_ajax_handler');




function vehicle_all_body_types_shortcode() {
    ob_start();

    // Define static images for each body type
    $body_type_images = [
        'Sedan'        => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-3-1.png',
        'Hatchback'    => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-10.png',
        'SUV'          => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-11.png',
        'Pickup Truck' => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-12.png',
        'Minivan'      => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-13.png',
        'Crossover'    => 'https://cas.test-links.com/wp-content/uploads/2025/01/image-14.png'
    ];

    // Fetch all vehicles
    $vehicles = get_posts([
        'post_type'      => 'vehicle',
        'posts_per_page' => -1
    ]);

    $body_types = [];

    // Loop through vehicles and count each body type
    foreach ($vehicles as $vehicle) {
        $body_type = get_post_meta($vehicle->ID, 'body_type', true);

        if ($body_type) {
            if (!isset($body_types[$body_type])) {
                $body_types[$body_type] = [
                    'count' => 0,
                    'image' => $body_type_images[$body_type] ?? 'https://via.placeholder.com/150',
                    'slug'  => sanitize_title($body_type) // Create slug for clickable link
                ];
            }
            $body_types[$body_type]['count']++;
        }
    }

    if (empty($body_types)) {
        return '<p>No body types available.</p>';
    }

    // Generate output
    echo '<div class="body-type-grid">';
    foreach ($body_types as $type => $data) {
        $link = site_url('/body-type/' . $data['slug']); // Adjust URL structure if needed
        ?>
        <a href="<?php echo esc_url($link); ?>" class="body-type-card">
            <img src="<?php echo esc_url($data['image']); ?>" alt="<?php echo esc_attr($type); ?>">
            <h3><?php echo esc_html($type); ?></h3>
            <p><?php echo esc_html($data['count']); ?> Cars</p>
        </a>
        <?php
    }
    echo '</div>';

    return ob_get_clean();
}
add_shortcode('vehicle_body_types', 'vehicle_all_body_types_shortcode');


function vehicle_body_type_results_shortcode() {
    ob_start();

    // Get the body type from the URL
    $body_type_slug = get_query_var('body-type');

    // Convert slug to readable format
    $body_type_name = ucwords(str_replace('-', ' ', $body_type_slug));

    if (empty($body_type_name)) {
        return '<p>No body type selected.</p>';
    }

    // Query vehicles with the selected body type
    $args = [
        'post_type'      => 'vehicle',
        'posts_per_page' => 20,
        'meta_query'     => [
            [
                'key'     => 'body_type',
                'value'   => $body_type_name,
                'compare' => '='
            ]
        ]
    ];

    $query = new WP_Query($args);

    // Display results
//     echo '<h2 class="body-type-heading">' . esc_html($body_type_name) . ' Vehicles</h2>';
    echo '<div id="vehicle-posts" class="vehicle-grid">';

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $price = get_post_meta(get_the_ID(), 'price', true) ?: 'N/A';
            $mileage = get_post_meta(get_the_ID(), 'mileage', true) ?: 'Unknown';
            $image = get_the_post_thumbnail_url(get_the_ID(), 'medium') ?: 'https://via.placeholder.com/300';
            $year = get_post_meta(get_the_ID(), 'year', true) ?: 'Unknown Year';
            $transmission = get_post_meta(get_the_ID(), 'transmission', true) ?: 'Unknown Transmission';
            $link = get_permalink();
            ?>
            <div class="vehicle-item">
                <a href="<?php the_permalink(); ?>" class="vehicle-link">
                    <div class="vehicle-image">
                        <?php if (has_post_thumbnail()): ?>
                            <img src="<?php echo get_the_post_thumbnail_url(); ?>" alt="<?php the_title(); ?>">
                        <?php endif; ?>
                    </div>
                    <div class="vehicle-content">
                        <p class="Body type"><?php the_field('body_type'); ?></p>
                        <h3 class="vehicle-title"><?php the_title(); ?></h3>
                        <div class="inner-col">
                            <p class="vehicle-year"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/calender.png"> <?php the_field('year'); ?></p>
                            <p class="Mileage"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/meter.png"><?php the_field('mileage'); ?></p>
                            <p class="vehicle-transmission"><img src="https://cas.test-links.com/wp-content/uploads/2025/02/gear.png"><?php the_field('transmission'); ?></p>
                        </div>
                        <p class="pricing">
							<?php 
								$price = get_field('price'); 
								if (!$price) {
									echo 'N/A'; // Show "N/A" if price is missing
								} elseif (strtolower(trim($price)) === 'sold') {
									echo '<span class="sold">SOLD</span>'; // Show "SOLD" without "$"
								} elseif (is_numeric(str_replace(',', '', trim($price)))) { 
									echo '$' . number_format((float) str_replace(',', '', trim($price)), 0); // Show price with "$"
								} else {
									echo esc_html($price); // Fallback for any unexpected input
								}
							?>
						</p>

                        <button class="view-butt"> View Car</button>
                    </div>
                </a>
            </div>
            <?php
        }
    } else {
        echo '<p>No vehicles found for this body type.</p>';
    }

    echo '</div>';
    wp_reset_postdata();
    
    return ob_get_clean();
}
add_shortcode('vehicle_body_type_results', 'vehicle_body_type_results_shortcode');


function add_body_type_rewrite_rule() {
    add_rewrite_rule('body-type/([^/]+)/?$', 'index.php?pagename=body-type&body-type=$matches[1]', 'top');
}
add_action('init', 'add_body_type_rewrite_rule');

// Register the query variable
function add_body_type_query_var($vars) {
    $vars[] = 'body-type';
    return $vars;
}
add_filter('query_vars', 'add_body_type_query_var');

// Flush rewrite rules on activation
function flush_rewrite_rules_on_activation() {
    add_body_type_rewrite_rule();
    flush_rewrite_rules();
}
register_activation_hook(__FILE__, 'flush_rewrite_rules_on_activation');

// Breadcrumb function with shortcode for custom post type
function cpt_breadcrumb_shortcode() {
    if (!is_singular()) {
        return '';
    }

    global $post;
    $breadcrumb = '<nav class="breadcrumb">';
    $breadcrumb .= '<a href="' . home_url() . '">Home</a> &raquo; ';

    $post_type = get_post_type_object(get_post_type());
    if ($post_type && $post_type->has_archive) {
        $breadcrumb .= '<a href="' . get_post_type_archive_link($post_type->name) . '">' . $post_type->labels->name . '</a> &raquo; ';
    }

    // Check for taxonomy terms if available
    $taxonomies = get_object_taxonomies(get_post_type(), 'objects');
    foreach ($taxonomies as $taxonomy) {
        $terms = wp_get_post_terms($post->ID, $taxonomy->name);
        if (!empty($terms) && !is_wp_error($terms)) {
            $term = $terms[0]; // Display only the first term
            $breadcrumb .= '<a href="' . get_term_link($term) . '">' . $term->name . '</a> &raquo; ';
        }
    }

    $breadcrumb .= '<span>' . get_the_title() . '</span>';
    $breadcrumb .= '</nav>';

    return $breadcrumb;
}
add_shortcode('custom_breadcrumb', 'cpt_breadcrumb_shortcode');



function vehicle_body_types_sidebar() {
    $vehicles = get_posts([
        'post_type'      => 'vehicle',
        'posts_per_page' => -1
    ]);

    $body_types = [];

    foreach ($vehicles as $vehicle) {
        $body_type = get_post_meta($vehicle->ID, 'body_type', true);
        if ($body_type && !in_array($body_type, $body_types)) {
            $body_types[] = $body_type;
        }
    }

    if (empty($body_types)) {
        return '<p>No body types available.</p>';
    }

    ob_start();
    echo '<div class="vehicle-body-sidebar">';
    echo '<h3>Body Types</h3>';
    echo '<ul>';
    foreach ($body_types as $type) {
        $link = site_url('/body-type/' . sanitize_title($type));
        echo '<li><a href="' . esc_url($link) . '">' . esc_html($type) . '</a></li>';
    }
    echo '</ul>';
    echo '</div>';

    return ob_get_clean();
}
add_shortcode('vehicle_body_types_sidebar', 'vehicle_body_types_sidebar');

function display_current_body_type_name() {
    $body_type_slug = get_query_var('body-type');
    if (!$body_type_slug) {
        return '';
    }

    $body_type_name = ucwords(str_replace('-', ' ', $body_type_slug));
    return '<h1 class="body-page-head">' . esc_html($body_type_name) . '</h1>';
}
add_shortcode('current_body_type', 'display_current_body_type_name');

function display_vehicle_price() {
    $price = get_field('price'); 

    if (!$price) {
        return '<span class="price">N/A</span>'; // Show "N/A" if price is missing
    }

    if (strtolower(trim($price)) === 'sold') {
        return '<span class="price sold">SOLD</span>'; // Show only "SOLD" without "$"
    }

    // Ensure proper number formatting
    if (is_numeric(str_replace(',', '', trim($price)))) {
        return '<span class="price">$' . number_format((float) str_replace(',', '', trim($price)), 0) . '</span>';
    }

    return '<span class="price">' . esc_html($price) . '</span>'; // Fallback for unexpected values
}
add_shortcode('vehicle_price', 'display_vehicle_price');
